﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace RevisionAnalyser.Controls
{
    public class LoadableForm : Form
    {
        private string _loadText;
        private bool _started = false;
        private LoadForm _load;

        public void ShowLoadScreen(string loadText)
        {
            Update();
            _loadText = loadText;
            _started = true;
            Thread sf = new Thread(new ThreadStart(ThreadedShowLoadForm));
            sf.Start();
        }

        public void HideLoadScreen()
        {
            if (_started)
            {
                while (_load == null)
                {
                    Thread.Sleep(100);
                }
                _load.Invoke(new EventHandler(_load.KillMe));
                _load.Dispose();
                _load = null;
                _started = false;
            }
        }

        private void ThreadedShowLoadForm()
        {
            _load = new LoadForm(_loadText);
            Application.Run(_load);
        }
    }
}
